' The Magic 8-Ball
' Rev 1.0.0 William M Leue 19-Jan-2024

option default integer
option base 1

' Constants
const BALLRAD = 200
const LABRAD  = 80
const WINRAD = 80
const LABXOF = 12
const LABYOF = -40
const LABCOL = rgb(255, 255, 190)
const TRADT8 = 27
const TRADB8 = 30
const TRADL8 = 10
const FACEZ  = 110
const NFACES = 20
const MAXLINES = 3
const NFADE  = 8
const CX = mm.hres\2
const CY = mm.vres\2

' Globals
dim numlines(NFACES)
dim answers$(NFACES, MAXLINES)

' Main Program
ReadAnswers
Instructions
DrawBall 1
HandleEvents
end

' Read the answers
sub ReadAnswers
  local i, j
  for i = 1 to NFACES
    read numlines(i)
    for j = 1 to numlines(i)
      read answers$(i, j)
    next j
  next i
end sub

' Instructions
sub Instructions
  local z$
  cls
  text mm.hres\2, 10, "Magic 8 Ball", "CT", 4,, rgb(100, 100, 255)
  print @(0, 40)
  print "The Magic 8 Ball Hears All, Sees All, Knows All, and sometimes Tells All!"
  print ""
  print "And because it Knows All, you need only THINK your question, then just"
  print "press any key on the keyboard to get your ABSOLUTELY CORRECT ANSWER!"
  text mm.hres\2, mm.vres-10, "Press Any Key to Continue", "CB"
  z$ = INKEY$
  do
    z$ = INKEY$
  loop until z$ <> ""
end sub  

' Draw the 8-Ball side 1: face, side2: answer window
sub DrawBall side
  local lx, ly
  cls rgb(white)
  circle CX, CY, BALLRAD,,, rgb(black), rgb(black)
  if side = 1 then
    lx = CX+LABXOF : ly = CY+LABYOF
    circle lx, ly, LABRAD,,, LABCOL, LABCOL
    circle lx, ly-TRADT8+4, TRADT8,, 1.2, rgb(black), rgb(black)
    circle lx, ly-TRADT8+4, TRADT8-TRADL8,, 1.2, LABCOL, LABCOL
    circle lx, ly+TRADB8-4, TRADB8,, 1.2, rgb(black), rgb(black)
    circle lx, ly+TRADB8-4, TRADB8-TRADL8,, 1.2, LABCOL, LABCOL
save image "Magic8ball"
  else
    circle CX, CY, WINRAD+5,,, rgb(gray)
    circle CX, CY, WINRAD,,, rgb(gray)
  end if
end sub

' User keyboard input
sub HandleEvents
  local z$
  do
    z$ = INKEY$
    do
      z$ = INKEY$
    loop until z$ <> ""
    if asc(z$) = 27 then
      cls
      end
    end if
    ShowAnswer
    pause 3000
    DrawBall 1      
  loop
end sub

' Gimme the answer, oh mystic oracle!
sub ShowAnswer
  local ax, a$(MAXLINES), nl, i, y, f, fc, tc, v
  local xv(3), yv(3)
  DrawBall 2
  ax = RandInt(1, NFACES)
  nl = numlines(ax)
  for i = 1 to nl
    a$(i) = answers$(ax, i)
  next i
  xv(1) = CX-FACEZ\2  : yv(1) = CY-FACEZ\2 + 12
  xv(2) = CX+FACEZ\2  : yv(2) = CY-FACEZ\2 + 12
  xv(3) = CX          : yv(3) = CY+FACEZ\2 + 12
  for f = 1 to NFADE
    v = f*32 - 1
    fc = rgb(0, 0, v)
    tc = rgb(v, v, v)
    polygon 3, xv(), yv(), fc, fc
    for i = 1 to nl
      ty = yv(1) + 10 + (i-1)*15
      text CX, ty, a$(i), "CM",,, tc, -1
    next i
    pause 200
  next f
end sub

' return a uniformly distributed random integer in the specified closed range
function RandInt(a as integer, b as integer)
  local integer v, c
  c = b-a+1
  do
    v = a + (b-a+2)*rnd()
    if v >= a and v <= b then exit do
  loop
  RandInt = v
end function

data 2, "It is",  "certain"
data 3, "It is",  "decidedly", "so"
data 2, "Without",  "a doubt"
data 2, "Yes", "definitely"
data 3, "You may", "rely on", "it"
data 3, "As I", "see it", "yes"
data 2, "Most", "likely"
data 2, "Outlook", "good"
data 1, "Yes"
data 2, "Signs point", "to yes"
data 2, "Reply hazy,", "try again"
data 2, "Ask again", "later"
data 3, "Better not", "tell you", "now"
data 3, "Cannot", "predict", "now"
data 3, "Concentrate", "and ask", "again"
data 2, "Don't count",  "on it"
data 2, "My reply", "is no"
data 2, "My sources", "say no"
data 3, "Outlook", "not so", "good"
data 2, "Very", "doubtful"

